/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import com.google.common.collect.Lists;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.misc.FlexEnchantment;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import java.util.List;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EnchantmentBuilder
extends BaseBuilder<FlexEnchantment, EnchantmentBuilder> {
    private Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;
    private EnchantmentCategory type = EnchantmentCategory.BREAKABLE;
    private EquipmentSlot[] slots = EquipmentSlot.values();
    private int minLevel = 1;
    private int maxLevel = 1;
    private int baseCost = 1;
    private int perLevelCost = 10;
    private int randomCost = 5;
    private List<ResourceLocation> blackList = Lists.newArrayList();
    private ItemPredicate itemCompatibility;
    private boolean isTreasure = false;
    private boolean isCurse = false;
    private boolean isTradeable = true;
    private boolean isDiscoverable = true;
    private boolean isAllowedOnBooks = true;

    public static EnchantmentBuilder begin(ThingParser<EnchantmentBuilder> ownerParser, ResourceLocation registryName) {
        return new EnchantmentBuilder(ownerParser, registryName);
    }

    private EnchantmentBuilder(ThingParser<EnchantmentBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Enchantment";
    }

    public void setRarity(Enchantment.Rarity rarity) {
        this.rarity = rarity;
    }

    public void setEnchantmentType(EnchantmentCategory type) {
        this.type = type;
    }

    public void setMinLevel(int minLevel) {
        this.minLevel = minLevel;
    }

    public void setMaxLevel(int macLevel) {
        this.maxLevel = macLevel;
    }

    public void setBaseCost(int baseCost) {
        this.baseCost = baseCost;
    }

    public void setPerLevelCost(int perLevelCost) {
        this.perLevelCost = perLevelCost;
    }

    public void setRandomCost(int randomCost) {
        this.randomCost = randomCost;
    }

    public void setIsTreasure(boolean treasure) {
        this.isTreasure = treasure;
    }

    public void setIsCurse(boolean curse) {
        this.isCurse = curse;
    }

    public void setIsTradeable(boolean tradeable) {
        this.isTradeable = tradeable;
    }

    public void setIsDiscoverable(boolean discoverable) {
        this.isDiscoverable = discoverable;
    }

    public void setItemCompatibility(ItemPredicate item_compatibility) {
        this.itemCompatibility = item_compatibility;
    }

    public void setBlacklist(List<ResourceLocation> blacklist) {
        this.blackList = blacklist;
    }

    @Override
    protected FlexEnchantment buildInternal() {
        FlexEnchantment flexEnchantment = new FlexEnchantment(this.rarity, this.type, this.slots);
        flexEnchantment.setMinLevel(this.minLevel);
        flexEnchantment.setMaxLevel(this.maxLevel);
        flexEnchantment.setBaseCost(this.baseCost);
        flexEnchantment.setPerLevelCost(this.perLevelCost);
        flexEnchantment.setRandomCost(this.randomCost);
        flexEnchantment.setItemCompatibility(this.itemCompatibility);
        flexEnchantment.setTreasure(this.isTreasure);
        flexEnchantment.setCurse(this.isCurse);
        flexEnchantment.setTradeable(this.isTradeable);
        flexEnchantment.setDiscoverable(this.isDiscoverable);
        flexEnchantment.setAllowedOnBooks(this.isAllowedOnBooks);
        flexEnchantment.setBlackList(this.blackList.stream().map(loc -> {
            RegistryObject ro = RegistryObject.create((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.ENCHANTMENTS);
            return enchantment -> ro.filter(en -> en == enchantment).isPresent();
        }).toList());
        this.constructEventHandlers(flexEnchantment);
        return flexEnchantment;
    }

    public EnchantmentBuilder setIsAllowedOnBooks(boolean allow_on_books) {
        this.isAllowedOnBooks = allow_on_books;
        return this;
    }
}

